/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::
::   Module      :   smxFFS API Header File
::   Copyright   :   (C)2004-2009 Woodward
::   Platform(s) :   MPC5xx
::   Limitations :   Dependant upon smxFFS Release1
::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/

#ifndef __SMXFFS_H
#define __SMXFFS_H

/*----- INCLUDES ------------------------------------------------------------------------------------------*/
#include <typedefn.h>
#include <Resource_FFS.h>
#include <NANDFlash_HAL.h>

/*----- DEFINES -------------------------------------------------------------------------------------------*/

/*----- TYPEDEFS ------------------------------------------------------------------------------------------*/
#pragma pack(1)

#pragma pack()
/*----- EXTERNALS -----------------------------------------------------------------------------------------*/

/*----- PROTOTYPES ----------------------------------------------------------------------------------------*/
NativeError_S  smxffsOpen(S_NANDFlashDevice const*, NativeVar_U in_uPagesPerCacheBlock);
void smxffsClose(void);

/* The smxFFS documentation uses v_function. eg v_ffs_fmount. The "v_" has been replaced with "smx" so that 
   the FILEHANDLE type could be converted into another type that hides the inner workings if the FILEHANDLE */
void           smxffs_funmount(void);
FFS_FILEHANDLE smxffs_fopen(char const* in_pszFileName, const char *mode, NativeError_S* out_pDetailedError);
void           smxffs_fclose(FFS_FILEHANDLE filehandle);
int            smxffs_fread(void *buf, NativeVar_S size, NativeVar_S items, FFS_FILEHANDLE filehandle);
int            smxffs_fwrite(void const* buf, NativeVar_S size, NativeVar_S items, FFS_FILEHANDLE filehandle);
int            smxffs_fseek(FFS_FILEHANDLE filehandle, NativeVar_S offset, E_FFSSeekOrigin);
NativeError_S  smxffs_fdelete(char const* filename);
int            smxffs_findfile(char const* filename);
int            smxffs_filelength(char const* filename);
char*          smxffs_fgetversion(void);

void           smxffs_rewind(FFS_FILEHANDLE filehandle);
int            smxffs_fflush(FFS_FILEHANDLE filehandle);
int            smxffs_ftell(FFS_FILEHANDLE filehandle);
void           smxffs_fsetend(FFS_FILEHANDLE filehandle);
int            smxffs_feof(FFS_FILEHANDLE filehandle);
NativeError_S  smxffs_rename(char const* in_pszOldName, char const* in_pszNewName);

FFS_SEARCH_HANDLE smxffs_findfirst(char const* in_pszFileSpec, NativeVar_U in_uSearchAttributes, S_FFSFindData* out_pFileInfo, NativeError_S* out_pDetailError);
NativeError_S  smxffs_findnext(FFS_SEARCH_HANDLE, S_FFSFindData* out_pFileInfo);
void           smxffs_FindFileClose(FFS_SEARCH_HANDLE hSearchHandle);

int            smxffs_fgetfilenum(char const* filespec);
int            smxffs_flushall(void);

float          smxffs_freespace(void);
int            smxffs_freesize(char const* in_pszDriveName);
int            smxffs_devicemounted(void);
int            smxffs_formaterror(void);

NativeVar_U    smxffs_GetPagesPerCacheBlock(void);

NativeError_S smxffs_error(FFS_FILEHANDLE in_hFileThatIssuedTheError);

#endif /* __SMXFFS_H */

/*----- END OF FILE ---------------------------------------------------------------------------------------*/
